#ifndef __MMcTrig__
#define __MMcTrig__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "TObject.h"

#include "../Simulation/Detector/include-MTrigger/MTriggerDefine.h"

class MMcTrig : public TObject {
 private:
  Short_t topology     ;    // Topology of the trigger
                                   // 0 = N-1 neighbours of one pixel
                                   // 1 = N neighbours
                                   // 2 = N closed pack
  Short_t multiplicity ;    // Pixel multiplicity of trigger configuration
  Float_t threshold[TRIGGER_PIXELS] ; // Threshold for trigger
  
  Short_t nZeroLevel   ;
  Short_t nFirstLevel  ;    // Number of First Level Trigger in this Event
  Short_t nSecondLevel ;    // Number of Second Level Trigger in this Event

  Float_t timeFirst;    // Time when it triggers
  Int_t pixelFirst;     // Pixel which triggers

 public:
  MMcTrig() ;

  ~MMcTrig(); 

  void Clear();
  
  void Print(Option_t *);

  void SetTopology(Short_t nTop) {
    topology=nTop;
  }

  void SetMultiplicity(Short_t nMul) {
    multiplicity=nMul;
  }

  void SetThreshold(Float_t fthr[]){
    int i;
    for(i=0;i<TRIGGER_PIXELS;i++){
      threshold[i]=fthr[i];
    }
  }

  void SetZeroLevel (Short_t nTr) {
    nZeroLevel = nTr ; 
  }

  void SetFirstLevel  ( Short_t nTr ) {
    nFirstLevel = nTr ; 
  } 
  void SetSecondLevel ( Short_t nTr ) {
    nSecondLevel = nTr ; 
  } 

  void SetTime( Float_t t){
    timeFirst=t;
  }

  void SetPixel( Int_t iPix){
    pixelFirst=iPix;
  }

  int GetFirstLevel() {
    return ( nFirstLevel );  
  }

  ClassDef(MMcTrig, 1)  //Stores Montecarlo Information 

};

#endif

