#include "MRawCrateData.h"

#include <iostream.h>
#include <iomanip.h>

#include <fstream.h>

ClassImp(MRawCrateData)

MRawCrateData::MRawCrateData() : fDAQCrateNumber(0), fFADCEvtNumber(0), fFADCClockTick(0)
{
}

void MRawCrateData::ReadEvt(ifstream& fin)
{
    //
    // read the information from a binary input stream about the CRATE DATA,
    // like specified in a TDAS note
    //
    fin.read((Byte_t*)&fDAQCrateNumber, 2);
    fin.read((Byte_t*)&fFADCEvtNumber,  4);
    fin.read((Byte_t*)&fFADCClockTick,  4);
}

void MRawCrateData::Print(Option_t *t)
{
    //
    // print all stored information to screen
    //
    cout << "Crate Number " << fDAQCrateNumber << ":  ";
    cout << "FADCEventNr=" << fFADCEvtNumber << "  ";
    cout << "FADCClockTick=" << fFADCClockTick << " (20MHz)" << endl;
}
