#include <iostream.h>

#include "TClonesArray.h"
#include "TString.h"
#include "TRandom.h"

#include "MRawCrate.h"

#include "Mdefine.h"

//==========
// MRawCrate 
//    
// One Event in the Camera of MAGIC consists of measurements of different
// Photomultiplier. The measurements are taken with FADCs wich are set in 
// several Crates. 
//
// The Class MRawCrate is used to store some usefull 
// infotmation of each create. 
//
// The data members are described in detail here: 
//
// ---------
//
// Byte_t     DAQCrateNumber ;   
//
// This is to identify the Crate 
//
// ---------
//
// UInt_t      FADCEvtNumber ;   
//
// Event number as determined by b internal counter in this 
// particular FADC crate. This number should be equal to DAQEvtNumber 
// but not to TriggerNumber. All the crates should have the same
// FADCEvtNumber so this number can be used to check the crate sinchronization.
//
// ---------
//
// UInt_t      FADCClockTick ; 
//
// Tick of the 20 MHz crate clock as determined using a counter in 
// the FADC crate. This tick will reset automatically to 0 every 50ns*2^32. 

ClassImp(MRawCrate) 



MRawCrate::MRawCrate() {
  //
  //  The default constructor sets all members to zero. 
  //

  DAQCrateNumber = 0 ;
  FADCEvtNumber = 0 ;
  FADCClockTick = 0 ;

}

MRawCrate::~MRawCrate(){
  //
  //  default destructor
  //
}

void MRawCrate::Clear(){
  // 
  //  Clear values
  //

  DAQCrateNumber = 0 ;
  FADCEvtNumber = 0 ;
  FADCClockTick = 0 ;
}
