#ifndef __MRawEvt__
#define __MRawEvt__

#include <iostream.h>
#include "TObject.h"
#include "TClonesArray.h"

#include "Mdefine.h" 

class MRawEvt : public TObject { 

 private: 
  UInt_t        DAQEvtNumber ;      // Number of Event

  UInt_t        AbsTime[2] ;        // Time of the Event
 
  UInt_t        FstLvlTrigNumber ;  // Number of 1st level tiggers between 2 events

  UInt_t        SecLvlTrigNumber ;  // Number of 2nd level tiggers between 2 events

  UInt_t        TriggerPattern[2] ; // Trigger configuration

  Byte_t       TriggerType ;       // Normal trigger 0, pedestal 1, calibration 2

  Byte_t       AllLowGainOn ;         // Flag indicating if any of the pixels have a 
                                    // non-negligible low gain signal (1) or not (0)

  TClonesArray  *Crates ;          // list of crates

  TClonesArray  *PixelsHigh   ;         // list of the events for the
                                        // high gain channel

  TClonesArray  *PixelsLow   ;         // list of the events for the low gain
                                       // channel if it has signifcant signal

 public: 

  MRawEvt() ; 

  ~MRawEvt(); 

  void Clear() ; 
  
  void Print() ; 

  void FillHeader( UInt_t, Float_t, Float_t = 0 ) ; 

  void FillPixel(Short_t, UShort_t *, Float_t * ) ; 
 
  void FillPixelLow(Short_t, UShort_t *, Float_t * ) ; 

  UShort_t GetMultPixel(); 

  TClonesArray *&GetPixelList() {
    //
    //   returns a Pointer to the pixel list
    //
    return  PixelsHigh ; 
  }
  
  ULong_t GetTimeStamp() {
    return (ULong_t) AbsTime[0]*4294967296+AbsTime[1]; 
  }
  
  
/*    void AddPixel( Short_t  ) ;  */

/*    void AddPixel ( Short_t, Byte_t, Byte_t * ) ;  */


  ClassDef ( MRawEvt, 1 )  

};  // end of class definition of MRawEvt

#endif
