//////////////////////////////////////////////////////////////////////////
//                                                                      //
// TNamed                                                               //
//                                                                      //
// The TNamed class is the base class for all named ROOT classes        //
// A TNamed contains the essential elements (name, title)               //
// to identify a derived object in containers, directories and files.   //
// Most member functions defined in this base class are in general      //
// overridden by the derived classes.                                   //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#include "MParContainer.h"

#include <iostream.h>    // cout

#include "TClass.h"      // IsA
#include "TROOT.h"       // TROOT::Identlevel
#include "TVirtualPad.h" // gPad

ClassImp(MParContainer)

//______________________________________________________________________________
MParContainer::MParContainer(const MParContainer &named)
{
   // TNamed copy ctor.
   *fName = *(named.fName);
   *fTitle = *(named.fTitle);
}

//______________________________________________________________________________
MParContainer& MParContainer::operator=(const MParContainer& rhs)
{
   // TNamed assignment operator.

   if (this != &rhs) {
      TObject::operator=(rhs);
      *fName  = *(rhs.fName);
      *fTitle = *(rhs.fTitle);
   }
   return *this;
}

//______________________________________________________________________________
Int_t MParContainer::Compare(TObject *obj)
{
   // Compare two TNamed objects. Returns 0 when equal, -1 when this is
   // smaller and +1 when bigger (like strcmp).

   if (this == obj) return 0;
   return fName->CompareTo(obj->GetName());
}

//______________________________________________________________________________
void MParContainer::Copy(TObject &obj)
{
   // Copy this to obj.

   TObject::Copy(obj);
   *(((MParContainer&)obj).fName)  = *fName;
   *(((MParContainer&)obj).fTitle) = *fTitle;
}

//______________________________________________________________________________
void MParContainer::FillBuffer(char *&buffer)
{
   // Encode TNamed into output buffer.

   fName->FillBuffer(buffer);
   fTitle->FillBuffer(buffer);
}

//______________________________________________________________________________
void MParContainer::ls(Option_t *)
{
   // List TNamed name and title.

   TROOT::IndentLevel();
   cout <<"OBJ: " << IsA()->GetName() << "\t" << GetName() << "\t" << GetTitle() << " : "
        << Int_t(TestBit(kCanDelete)) << endl;
}

//______________________________________________________________________________
void MParContainer::Print(Option_t *)
{
   // Print TNamed name and title.

   cout <<"OBJ: " << IsA()->GetName() << "\t" << GetName() << "\t" << GetTitle() << endl;
}

//______________________________________________________________________________
void MParContainer::SetName(const char *name)
{
   // Change (i.e. set) the name of the TNamed.
   // WARNING !!
   // If the object is a member of a THashTable, THashList container
   // The HashTable must be Rehashed after SetName
   // For example the list of objects in the current directory is a THashList

   *fName = name;
   if (gPad && TestBit(kMustCleanup)) gPad->Modified();
}

//______________________________________________________________________________
void MParContainer::SetObject(const char *name, const char *title)
{
   // Change (i.e. set) all the TNamed parameters (name and title).
   // See also WARNING in SetName

   *fName  = name;
   *fTitle = title;
   if (gPad && TestBit(kMustCleanup)) gPad->Modified();
}

//______________________________________________________________________________
void MParContainer::SetTitle(const char *title)
{
   // Change (i.e. set) the title of the TNamed.

   *fTitle = title;
   if (gPad && TestBit(kMustCleanup)) gPad->Modified();
}

//______________________________________________________________________________
Int_t MParContainer::Sizeof() const
{
   // Return size of the TNamed part of the TObject.

   Int_t nbytes = fName->Sizeof() + fTitle->Sizeof();
   return nbytes;
}







