#include <iostream.h>

#include "TString.h"
#include "TRandom.h"

#include "MRawPixel.h"

#include "Mdefine.h"

//==========
// MRawPixel 
//    
// One Event in the Camera of MAGIC consists of measurements of different
// Photomultiplier. The measurements are taken with FADCs. So the raw 
// informations of one pixel are the ADC values of the FADCs. MAGIC will
// measure the amplitude of one Photomulitplier in different branches 
// - one high and one low gain branch. The first is for small signals, the 
// other for big signals. With this method it is possible to increase the 
// dynamic range.  
//
// The Class MRawPixel is used to manage this raw information. 
//
// The data members are described in detail here: 
//
// ---------
//
// Short_t     PixelId     ;   
//
// This is to identify the Pixel.
// The Camera consists of CAMERA_PIXELS Pixels. Each one has a specific Id.
// The center of the camera is zero and a spiral numbering is chosen.
//
// To reduce the amount of data, we store the information of the 
// low-gain-branch of the Fadcs only if there is a signal in. Then the 
// PixelId is:
//                   PixelId = - PixelId   . 
// if there is an entry in the low gain list.
//
// Otherwise Fadc values the rule is:
//                   PixelId = PixelId . 
//
//
// ---------
//
// Byte_t    FADCSamples[FADC_SLICES] ; 
//
// The values of FADC_SLICES fadc-slices. This is the information of the 
// measured ADC values for one branch (high gain or low gain). The typ of 
// branch is indicated in the usPixelNumber and in the PixelStatus.
// In this first version the number of FADC_SLICES is going to be fixed

ClassImp(MRawPixel) 



MRawPixel::MRawPixel() {
  //
  //  The default constructor sets all members to zero. 
  //
    
  PixelId     = 0 ; 

  for (Int_t i = 0; i<FADC_SLICES; i++) 
    FADCSamples[i]   = 0 ; 

}


MRawPixel::MRawPixel(Short_t PId) {
  //
  //  constructor II  overloaded
  //
  //  Parameter is the PixelId. All other data member are set to zero
  
  PixelId     = PId ; 
  for (Int_t i = 0; i<FADC_SLICES; i++) 
     FADCSamples[i]   = 0 ; 

}


MRawPixel::MRawPixel(Short_t usPId, Byte_t ucF[]) {
  //
  // constructor III overloaded 
  //
  // parameters are PixelId and an array with Fadc values.
  
  PixelId     = usPId ; 
  
   for (Int_t i = 0; i<FADC_SLICES; i++) 
    FADCSamples[i]   = ucF[i] ; 
}

MRawPixel::~MRawPixel(){
  //
  //  default destructor
  //
}

void MRawPixel::Clear() {
  //
  //  Sets the data member back to zero
  //
  PixelId     = 0 ; 

  for (Int_t i=0;i<FADC_SLICES; i++){
  FADCSamples[i] = 0;
  }
} 

void MRawPixel::Print() 
{
  //
  //  This member function prints all Data of one Pixel on screen. 
  //

  cout << endl << "PixId " << PixelId          ; 

  for (Int_t i=0 ; i<FADC_SLICES ; i++ ) {
    cout<<" / " << FADCSamples[i]; 
  } 
}

void MRawPixel::FillPixel (Short_t usPId, Byte_t ucF[]){
  //
  //  Fills the event information
  //

  PixelId= usPId;

  for (Int_t i = 0; i<FADC_SLICES; i++){
    FADCSamples[i]= ucF[i];
  } 

}

Short_t MRawPixel::GetPixelId() {
  //
  // returns back the PixelId of the Pixel
  //
  return PixelId;
}

Byte_t MRawPixel::GetFadcSlice( Int_t iSli ) {
  //
  // returns back the fadc content of the slice iSli 
  //

    return (FADCSamples[iSli]) ;
}
