/////////////////////////////////////////////////////////////////////////////
//
// MRawCrateArray
//
// This class exists to make it possible to read in the crate data
// TClones Array. In principal we can directly write the TClonesArray
// to the root file, but when we read in again the root file we cannot
// put the TClonesArray into our parameter list, becaus it isn't derived
// from TNamed. This class is derived from TNamed and can be put in the list
//
/////////////////////////////////////////////////////////////////////////////
#include "MRawCrateArray.h"

#include <iostream.h>

#include <TClonesArray.h>

ClassImp(MRawCrateArray)

MRawCrateArray::MRawCrateArray(const char *name, const char *title)
{
    *fName  = name  ? name  : "MRawCrateArray";
    *fTitle = title ? title : "Array of MRawCrateData Information";

    //
    // craete an (almost) empty array. The size is easily determined
    // while filling the array
    //
    fArray = new TClonesArray("MRawCrateData", 0);
}

MRawCrateArray::~MRawCrateArray()
{
    delete fArray;
}

void MRawCrateArray::Clear(Option_t *opt)
{
    //
    // clear the entries in the TClonesArray
    //
    fArray->Clear();
}

void MRawCrateArray::Print(Option_t *opt)
{
    cout << "MRawCrateArray::Print()" << endl;
}

MRawCrateData *MRawCrateArray::GetEntry(Int_t i)
{
    //
    // Return a pointer the i-th entry in the array
    //
    return (MRawCrateData*)fArray->AddrAt(i);
}

MRawCrateData* &MRawCrateArray::operator[](Int_t i)
{
    //
    // Return the i-th entry in the array
    //
    return (MRawCrateData*&)(*fArray)[i];
}

TClonesArray **MRawCrateArray::GetArray()
{
    //
    // return a pointer to the pointer of the array
    // (actually not used. You may need it if you want to write
    //  the TClonesArray directly)
    //
    return &fArray;
}

