#ifndef MPARCONTAINER_H
#define MPARCONTAINER_H

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// TNamed                                                               //
//                                                                      //
// The basis for a named object (name, title).                          //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#include <iostream.h>    // cout

#ifndef ROOT_TObject
#include <TObject.h>
#endif
#ifndef ROOT_TString
#include <TString.h>
#endif

class MParContainer : public TObject
{
 private:
    void Init(const char *name, const char *title)
	{
	  fName = new TString;
	  (*fName) = name;
	  fTitle = new TString;
	  (*fTitle) = title;
	}
 protected:
    TString   *fName;            //! object identifier
    TString   *fTitle;           //! object title
    
 public:
    MParContainer(const char *name="", const char *title="") { Init(name, title); }
     MParContainer(const TString &name, const TString &title)  { Init(name, title); }
     MParContainer(const MParContainer &named);
     MParContainer& operator=(const MParContainer& rhs);
     virtual ~MParContainer() { 
       //delete fName; delete fTitle;
     }
     virtual Int_t    Compare(TObject *obj);
     virtual void     Copy(TObject &named);
     virtual void     FillBuffer(char *&buffer);
     virtual const char  *GetName() const {return fName->Data();}
     virtual const char  *GetTitle() const {return fTitle->Data();}
     virtual ULong_t  Hash() { return fName->Hash(); }
     virtual Bool_t   IsSortable() const { return kTRUE; }
     virtual void     SetName(const char *name); // *MENU*
     virtual void     SetObject(const char *name, const char *title);
     virtual void     SetTitle(const char *title=""); // *MENU*
     virtual void     ls(Option_t *option="");
     virtual void     Print(Option_t *option="");
     virtual Int_t    Sizeof() const;
     
     ClassDef(MParContainer, 1)  //The basis for Parameter Containers
};

#endif


