#include <iostream.h>
#include "MMcTrigHeader.hxx"


//==========
// MMcTrigHeader
//    
// This class contains the MonteCarlo information
// of the trigger simulation for the current run.
// The information is saved only once, whatever the
// number of events is
 


ClassImp(MMcTrigHeader)



MMcTrigHeader::MMcTrigHeader() {
  //
  //  default constructor
  //  set all values to zero

  Int_t i;

  fTopology     = -1 ;
  fMultiplicity = -1 ;
  for(i=0;i<TRIGGER_PIXELS;i++){
    fThreshold[i] = -1.0;
  }
  
  fTrigPattern[0]=0;
  fTrigPattern[1]=0;

  fTrigShape=0.0; 
  fAmplTrig=RESPONSE_AMPLITUDE;
  fFwhmTrig=RESPONSE_FWHM;
  fOverlapingTime=TRIGGER_OVERLAPING;
  fGateLeng=TRIGGER_GATE ;
}

MMcTrigHeader::~MMcTrigHeader() {
  //
  //  default destructor
  //
}


void MMcTrigHeader::Print(Option_t *Option) {
  //
  //  print out the data member on screen
  //

  cout <<endl << "Monte Carlo Trigger output:" <<endl;
  cout << " XSTopology Trigger in this run : "<<fTopology<<endl;
  cout << " Multiplicity Trigger in this run : "<<fMultiplicity<<endl;
  cout << " Trigger Pattern in this run : "<<fTrigPattern[0]<<
    fTrigPattern[1]<<endl;
  cout << endl ; 
}
