#ifndef MCT1READASCII_H
#define MCT1READASCII_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class TList;
class MCerPhotEvt;
class MPedestalCam;

class MCT1ReadAscii : public MTask
{
private:
    ifstream     *fIn;          // the inputfile
    MCerPhotEvt  *fNphot;       // the data container for all data.
    MPedestalCam *fPedest;      // ct1 pedestals
    TList        *fFileNames;   // Array which stores the \0-terminated filenames

    Bool_t OpenNextFile();

    void ReadPedestals();
    void ReadData();

public:
    MCT1ReadAscii(const char *filename=NULL,
                  const char *name=NULL,
                  const char *title=NULL);

    ~MCT1ReadAscii();

    void AddFile(const char *fname);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCT1ReadAscii, 0)	// Reads the CT1 data file
};

#endif

