#ifndef MEVTLOOP_H
#define MEVTLOOP_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MEvtLoop                                                                //
//                                                                         //
// Class to execute the tasks in a tasklist                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MParList;
class MTaskList;

class MEvtLoop : public MParContainer
{
private:
    MParList  *fParList;
    MTaskList *fTaskList;

    enum { kIsOwner = BIT(14) };

public:
    MEvtLoop();
    virtual ~MEvtLoop();

    void SetParList(MParList *p)        { fParList = p; }
    MParList *GetParList() const        { return fParList; }

    void SetOwner(Bool_t enable=kTRUE);

    Bool_t PreProcess(const char *tlist="MTaskList");
    void   Process(Int_t maxcnt) const;
    Bool_t PostProcess() const;

    Bool_t Eventloop(Int_t maxcnt=-1, const char *tlist="MTaskList");

    ClassDef(MEvtLoop, 0) // Class to execute the tasks in a tasklist
};

#endif
