/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////
//
// MHFadcCam
//
// This class contains a list of MHFadcPix.
//
///////////////////////////////////////////////////////////////////////

#include "MHFadcCam.h"

#include "MRawEvtData.h"
#include "MRawEvtPixelIter.h"

ClassImp(MHFadcCam);

// --------------------------------------------------------------------------
//
//  default constructor
//  creates an a list of histograms for all pixels and both gain channels
//
MHFadcCam::MHFadcCam (const char *name, const char *title)
{
    //
    //   set the name and title of this object
    //
    
    fName  = name  ? name  : "MHFadcCam" ;
    fTitle = title ? title : "Container for ADC spectra histograms" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //
    fArray = new TObjArray(577);

    for (Int_t i=0; i<577; i++)
        (*fArray)[i] = new MHFadcPix(i);
}

// --------------------------------------------------------------------------
MHFadcCam::~MHFadcCam ()
{
    delete fArray;
}

// --------------------------------------------------------------------------
void MHFadcCam::Fill(const MParContainer *par)
{
    MRawEvtData *evt = (MRawEvtData*)par;

    MRawEvtPixelIter pixel(evt);

    const Int_t nhisamples = evt->GetNumHiGainSamples();
    const Int_t nlosamples = evt->GetNumLoGainSamples();

    while (pixel.Next())
    {
        const UInt_t id = pixel.GetPixelId();

        for (Int_t i=0;  i<nhisamples; i++)
            FillHi(id, pixel.GetHiGainFadcSamples()[i]);

        if (!pixel.HasLoGain())
            continue;

        for (Int_t i=0; i<nlosamples; i++)
            FillLo(id, pixel.GetLoGainFadcSamples()[i]);
    }

}
/*void MHFadcCam::SaveHist(char *name)
{
    //
    //   save all histogram in this class to a root file
    //

    //
    // FIXME: Don't open a file and write to this file!
    // just Fill the current container (or the two histograms
    // to an open file. The user must choose a file before.
    //
    TFile out( name, "recreate") ;

    //
    //  loop over all pixels and write the files out
    //

    fHistLo->Write();
    fHistHi->Write();
}

  */