#ifndef MRAWCRATEDATA_H
#define MRAWCRATEDATA_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

class ifstream;

class MRawCrateData : public TObject
{
private:
    UShort_t fDAQCrateNumber;  // Crate number the information corresponds to
    UInt_t   fFADCEvtNumber;   // event number from the fadc
    UInt_t   fFADCClockTick;   // clock tick from the fadc (20MHz)

public:
    MRawCrateData();

    UChar_t GetDAQCrateNumber() const  { return fDAQCrateNumber; }
    UInt_t  GetFADCEvtNumber() const   { return fFADCEvtNumber;  }
    UInt_t  GetFADCClockTick() const   { return fFADCClockTick;  }

    void Print(Option_t *t=NULL) const;

    void ReadEvt(istream& fin);

    ClassDef(MRawCrateData, 1) //Container to store the Raw CRATE DATA
};

#endif
