#ifndef STARGUIDER_H
#define STARGUIDER_H

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif
#ifndef CAMERA_H
#include "Camera.h"
#endif

#include "MGList.h"
#include "MGImage.h"
#include "StarCatalog.h"

class TGMenuBar;
class TGPopupMenu;

class MGImage;
class MGCoordinates;

class Starguider : public Camera, public TGMainFrame
{
private:
    MGList         fList;

    TGMenuBar     *fMenu;
    MGImage       *fImage;

    TGPopupMenu   *fDisplay;
    TGPopupMenu   *fWrite;
    TGPopupMenu   *fFileType;
    TGPopupMenu   *fWriteType;
    TGPopupMenu   *fWriteRate;
    TGPopupMenu   *fSetup;
    TGPopupMenu   *fLimMag;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    StarCatalog    fSao;

    RaDec fRaDec;

    int fWrtRate;

    void SetPixSize(const double pixsize);

public:
    Starguider();
    virtual ~Starguider();

    void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);
};

#endif
