#ifndef SLALIB_H
#define SLALIB_H

#include "coord.h"
#include "base/timer.h"

class Slalib : public Timer
{
private:
    double   fAlpha;
    double   fMjd;

    double   fPhi;      // location of observatory
    double   fElong;

public:
    Slalib();
    virtual ~Slalib();

    //    const AltAz GetAltAz() const { return fAltAz*360/D2PI; }
    //    const ZdAz  GetZdAz()  const { return ZdAz(DPI/2-fAltAz.Alt(), fAltAz.Az())*360/D2PI; }
    //    const RaDec GetRaDec() const { return fRaDec*360/D2PI; }

    void SetMjd2Now();
    void SetMjd(const struct timeval *tm);

    virtual void SetMjd(const double mjd);

    double GetAlpha() const { return fAlpha; }
    double GetMjd() const   { return fMjd; }

    double GetPhi() const   { return fPhi; }
    double GetElong() const { return fElong; }

    ZdAz   XYZ2ZdAz(double coord[3]) const;
};

#endif
