#ifndef MGCOORDINATE_H
#define MGCOORDINATE_H

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif
#ifndef MGLIST_H
#include "MGList.h"
#endif

enum {
    kETypeDeg,
    kETypeH
};

class TGLabel;
class TGTextEntry;

class MGCoordinate : public TGFrame
{
    Int_t fDeg;
    Int_t fMin;
    Int_t fSec;

    MGList fList;

    TGTextEntry *fTextEntryDeg;
    TGTextEntry *fTextEntryMin;
    TGTextEntry *fTextEntrySec;

    TGLabel     *fLabelDeg;
    TGLabel     *fLabelMin;
    TGLabel     *fLabelSec;

    TGLabel     *fLabel;

    void   Set(TGLabel     *label, const Int_t val);
    void   Set(TGTextEntry *entry, const Int_t val);
    Bool_t Set(TGLabel     *label, Int_t &val, TGTextEntry *label);

public:
    MGCoordinate(const TGWindow* p, const Int_t type=kETypeDeg,
                 const Bool_t flag=kTRUE, const char *txt="Coordinates:",
                 const Int_t deg=0, const UInt_t min=0, const UInt_t sec=0);
    ~MGCoordinate();

    Double_t GetVal() const;
    void SetVal(Double_t d);

    Bool_t ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2);

    void Print();
};

#endif // MGIMAGE_H
