#ifndef MGEMBEDDEDCANVAS_H
#define MGEMBEDDEDCANVAS_H

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)


#ifndef ROOT_TRootEmbeddedCanvas
#include <TRootEmbeddedCanvas.h>
#endif

class TList;
class TCanvas;

class MGEmbeddedCanvas : public TRootEmbeddedCanvas
{
private:
    Bool_t fModified;

protected:

    TCanvas    *fCanvas;
    TList      *fList;

    const UInt_t  fWidth;
    const Float_t fRange;
    const Float_t fPix;

    void InitCanvas();

public:
    MGEmbeddedCanvas(const char *name, const TGWindow* p,
                     const UInt_t width, const Float_t range);
    ~MGEmbeddedCanvas();

    void UpdateCanvas();

    void SetModified() { fModified = kTRUE; }
};

#endif // MGSKYPOSITION_H
