#ifndef MARS_MGeomPix
#define MARS_MGeomPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MGeomPix : public MParContainer
{ 
private:
    Float_t fX;  // the x coordinate
    Float_t fY;  // the y coordinate
    Float_t fR;  // the r coordinate

    Byte_t  fNumNeighbors; // number of valid neighbors
    Short_t fNeighbors[6]; // the IDs of the pixel next to it
                           // we are assuming an hexagonal geometry

public:
    MGeomPix(Float_t x=0, Float_t y=0, Float_t r=0);

    void Print(Option_t *opt=NULL) const;

    void Set (Float_t x, Float_t y, Float_t r) { fX=x; fY=y; fR=r; }

    void SetNeighbors(Short_t i0=-1, Short_t i1=-1, Short_t i2=-1,
                      Short_t i3=-1, Short_t i4=-1, Short_t i5=-1);

    void SetX (Float_t x) { fX = x; }
    void SetY (Float_t y) { fY = y; }
    void SetR (Float_t r) { fR = r; }

    Float_t GetX() const  { return fX; }
    Float_t GetY() const  { return fY; }
    Float_t GetR() const  { return fR; }

    Byte_t GetNumNeighbors() const { return fNumNeighbors; }
    Short_t GetNeighbor(Byte_t i) const { return fNeighbors[i]; }

    ClassDef(MGeomPix, 1) // Geometry class describing the geometry of one pixel
};

#endif

