#ifndef MGVELOCITY_H
#define MGVELOCITY_H

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#ifndef MGEMBEDDEDCANVAS_H
#include "MGEmbeddedCanvas.h"
#endif

class TList;
class TText;
class TArrow;
class TCanvas;

class XY;
class ZdAz;
class SlaPlanets;

class MGVelocity : public MGEmbeddedCanvas
{
    TArrow *fArrow;

    TArrow *fArrowX;
    TArrow *fArrowY;

    TArrow *fArrowAvg;

    TText *fText;
    TText *fTextVel;

    XY *fOld;
    XY *fAvg;
    Char_t fPos;

    Float_t fScale;

    Bool_t UpdateAvg(const float x, const float y);

    void InitVelocity();
    void DrawCoordinateSystem();
    void UpdateText();
    void UpdateVelText(Float_t x, Float_t y);

public:
    MGVelocity(const TGWindow* p, const char *name, const UInt_t w);
    ~MGVelocity();

    void Update(ZdAz &pos);
};

#endif // MGSKYPOSITION_H
