#ifndef MARS_MTime
#define MARS_MTime

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MTime                                                                   //
//                                                                         //
// A generalized MARS time stamp                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MTime : public MParContainer
{
private:
    UInt_t fTimeStamp[2]; // type of raw event which should be processed by this task
    UInt_t fDuration;     // time of validity

public:

    MTime(const char *name=NULL, const char *title=NULL)
    {
        fName = name ? name : ClassName();
        fTitle = title;

        SetTime(0, 0);
    }

    MTime(UInt_t t1, UInt_t t0) 
    {
        SetTime(t1, t0);
    }

    MTime(MTime& t)
    {
        fTimeStamp[0] = t.fTimeStamp[0];
        fTimeStamp[1] = t.fTimeStamp[1];
        fDuration = t.fDuration;
    }

    void operator=(MTime &t)
    {
        fTimeStamp[0] = t.fTimeStamp[0];
        fTimeStamp[1] = t.fTimeStamp[1];
        fDuration = t.fDuration;
    }

    ~MTime() {}

    void Print(Option_t *t=NULL) const;

    void SetTime(UInt_t t1, UInt_t t0)
    {
	fTimeStamp[0] = t1;
	fTimeStamp[1] = t0;
    }

    void SetDuration(UInt_t t)
    {
	fDuration = t;
    }

    MTime *GetTime()
    {
        return this;
    }

    UInt_t GetTimeLo()
    {
	return fTimeStamp[0];
    }
    UInt_t GetTimeHi()
    {
	return fTimeStamp[1];
    }

    UInt_t GetDuration()
    {
	return fDuration;
    }

    ClassDef(MTime, 1)	//A generalized MARS time stamp
};

inline Bool_t operator<(MTime &t1, MTime &t2)
{
    return (t1.GetTimeHi()<=t2.GetTimeHi()) && (t1.GetTimeLo()<t2.GetTimeLo());
}

inline Bool_t operator>(MTime &t1, MTime &t2)
{
    return (t1.GetTimeHi()>=t2.GetTimeHi()) && (t1.GetTimeLo()>t2.GetTimeLo());
}

inline Bool_t operator<=(MTime &t1, MTime &t2)
{
    return (t1.GetTimeHi()<=t2.GetTimeHi()) && (t1.GetTimeLo()<=t2.GetTimeLo());
}

inline Bool_t operator>=(MTime &t1, MTime &t2)
{
    return (t1.GetTimeHi()>=t2.GetTimeHi()) && (t1.GetTimeLo()>=t2.GetTimeLo());
}

inline Bool_t operator==(MTime &t1, MTime &t2)
{
    return (t1.GetTimeLo()==t2.GetTimeLo()) && (t1.GetTimeHi()==t2.GetTimeHi());
}

#endif
