#ifndef __MMcFadcHeader__
#define __MMcFadcHeader__

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#include "MFadcDefine.h"

class MMcFadcHeader : public MParContainer{
 private:

  Float_t  fFadcShape   ;   // a number that indicate the shape type of 
                            // the signal   
                            // = 0 --> a gaussian  
  Float_t  fAmplFadc    ;   // the amplitude of the trigger in mV
  Float_t  fFwhmFadc    ;   // the width of the signal in nsec
  Float_t  fPedesMean[MFADC_CHANNELS]    ;  //  The mean value for the pedestal
                                            //  of each pixel (channel)
  Float_t  fElecNoise[MFADC_CHANNELS]   ;  //  The rms value in the pedestal 
                                           //  due to the electronics for
                                           //  each pixel (channel)

 public:
  MMcFadcHeader(const char *name=NULL, const char *title=NULL);

  ~MMcFadcHeader(); 

  void Print(Option_t *opt=NULL) const;
  
  void SetShape(Float_t shape){
    fFadcShape=shape;
  }

  void SetAmplitud(Float_t amp){
    fAmplFadc=amp;
 }

  void SetFwhm(Float_t fwhm){
    fFwhmFadc=fwhm;
  }

  void SetPedestal(Float_t *mean, Int_t dim){
    for (Int_t i=0;i<dim;i++)
      fPedesMean[i]=mean[i];
  }

  void SetElecNoise(Float_t *sigma, Int_t dim){
    for (Int_t i=0;i<dim;i++)
      fElecNoise[i]=sigma[i];
  }
  
  Float_t GetPedestal(UInt_t i) const    { return fPedesMean[i]; }
  Float_t GetPedestalRms(UInt_t i) const { return fElecNoise[i]; }
  Float_t GetAmplitud() const { return fAmplFadc; }

  UInt_t GetNumPixel() const { return MFADC_CHANNELS; }

  ClassDef(MMcFadcHeader, 1)  //Stores Montecarlo Information describing the FADC behaviour

};

#endif

