#ifndef MARS_MMcPedestalNSBAdd
#define MARS_MMcPedestalNSBAdd

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcPedestalNSBAdd                                                          //
//                                                                         //
// This task adds the contribution to pedestal rms from the NSB in the     //
// MARS Container (MPedestals).                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcFadcHeader;
class MPedestalCam;
class MRawRunHeader;
class MMcRunHeader;

class MMcPedestalNSBAdd : public MTask
{

    Float_t fDnsbPixel;

public:
    MMcPedestalNSBAdd(const Float_t difnsb = -1.0,
		   const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);

    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MMcPedestalNSBAdd, 0)   // Task which adds the NSB fluctuations to the pedestals rms
};

#endif
