#ifndef MARS_MBlindPixels
#define MARS_MBlindPixels

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayC
#include <TArrayC.h>
#endif

class MBlindPixels : public MParContainer
{
private:
    TArrayC fPixels; // Boolean value for every pixel 0=on, 1=blind

public:
    MBlindPixels(const char *name=NULL, const char *title=NULL);

    void SetPixelBlind(UShort_t id, Bool_t val=kTRUE);
    void AdoptPixels(Char_t pixels[577]) { fPixels.Adopt(577, pixels); }

    void Clear(Option_t *o="")  { fPixels.Reset(); }

    Bool_t IsBlind(UShort_t id) { return (Bool_t)fPixels[id]; }

    ClassDef(MBlindPixels, 1)    // container of Blind pixels
}; 

#endif

