#ifndef MARS_MPedestalCam
#define MARS_MPedestalCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MPedestalPix
#include "MPedestalPix.h"
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class MPedestalCam : public MParContainer
{
private:
    TClonesArray *fArray;

public:
    MPedestalCam(const char *name=NULL, const char *title=NULL);
    ~MPedestalCam();

    void InitSize(const UInt_t i) { fArray->ExpandCreate(i); }

    MPedestalPix &operator[](Int_t i)       { return *(MPedestalPix*)fArray->UncheckedAt(i); }
    MPedestalPix &operator[](Int_t i) const { return *(MPedestalPix*)fArray->UncheckedAt(i); }

    Bool_t CheckBounds(UInt_t i);

    ClassDef(MPedestalCam, 1)	// Storage Container for all pedestal information of the camera
};

#endif

