#ifndef MARS_MHStarMap
#define MARS_MHStarMap

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH2
#include <TH2.h>
#endif

class MHillas;

class MHStarMap : public MH
{
private:
    TH2F *fStarMap;

    void PrepareDrawing() const;

public:
    MHStarMap(const char *name=NULL, const char *title=NULL);
    ~MHStarMap();

    Bool_t Fill(const MParContainer *par);

    TH2F *GetHist() { return fStarMap; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHStarMap, 1) // Container to hold 2-dim histogram (starmap)
};

#endif
