#ifndef MARS_MDataValue
#define MARS_MDataValue

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MDataValue                                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MData
#include "MData.h"
#endif

class MDataValue : public MData
{
private:
    Double_t fValue;

public:
    MDataValue(Double_t v) : fValue(v)
    {
    }

    Double_t GetValue() const { return fValue; }
    Bool_t PreProcess(const MParList *plist) { return kTRUE; }

    Bool_t IsValid() const { return kTRUE; }

    void Print(Option_t *opt = "") const;

    ClassDef(MDataValue, 0) // MData object corresponding to a single value
};

#endif
