#ifndef MARS_MHAlphaEnergyTime
#define MARS_MHAlphaEnergyTime

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include "TH3.h"
#endif

#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MHillasSrc;
class MEnergyEst;
class MTime;
class TH2D;
class MParList;

class MHAlphaEnergyTime : public MH
{
private:
    MHillasSrc *fHillas; //!
    MEnergyEst *fEnergy; //!
    MTime      *fTime;   //!

    TH3D    fHist;


public:
    MHAlphaEnergyTime(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH3D *GetHist()       { return &fHist; }
    const TH3D *GetHist() const { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    void Subtract(const TH3D *h1, const TH3D *h2);
    void Subtract(const MHAlphaEnergyTime *h1, const MHAlphaEnergyTime *h2)
    {
        Subtract(h1->GetHist(), h2->GetHist());
    }

    TH2D *DrawAlphaProjection(Axis_t lo, Axis_t up, Option_t *opt="");
    TH2D *GetAlphaProjection(Axis_t lo, Axis_t up);

    ClassDef(MHAlphaEnergyTime, 1) //3D-histogram in alpha, Energy and time
};

#endif






