#ifndef MARS_MHillasCalc
#define MARS_MHillasCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHillasCalkc                                                            //
//                                                                         //
// Task to calculate Hillas Parameters                                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;

class MHillasCalc : public MTask
{
    const MGeomCam    *fGeomCam;    // Camera Geometry used to calculate Hillas
    const MCerPhotEvt *fCerPhotEvt; // Cerenkov Photon Event used for calculation
          MHillas     *fHillas;     // ouput container to store result

    TString fHilName;
public:
    MHillasCalc(const char *hil="MHillas", const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MHillasCalc, 0)   // Task to calculate Hillas parameters
};

#endif
