#ifndef MARS_MHMatrix
#define MARS_MHMatrix

#ifndef ROOT_TMatrix
#include <TMatrix.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class MDataChain;

class MHMatrix : public MH
{
protected:
    Int_t   fNumRow; //! Number of dimensions of histogram
    TMatrix fM;      // Matrix to be filled

    TMatrix fM2;     //!

    TList  *fData;   //! List of data members (columns)
    TList  *fRules;  // List of data members as text for storage

    void AddRow();

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);
    Bool_t Finalize();

public:
    MHMatrix(const char *name=NULL, const char *title=NULL);
    ~MHMatrix();

    void AddColumn(const char *name);
    void AddColumns(const MHMatrix *matrix);

    //    TMatrix &GetM() { return fM; }
    const TMatrix &GetM() const { return fM; }
    const TList *GetRules() const { return fRules; }

    //void Draw(Option_t *opt=NULL);
    //TObject *DrawClone(Option_t *opt=NULL) const;

    void Print(Option_t *) const;

    const TMatrix *InvertPosDef();

    Double_t CalcDist(const TMatrix &m, const TVector &v, Int_t num = 25) const;
    Double_t CalcDist(const TVector &v, Int_t num = 25);

    void Reassign();

    ClassDef(MHMatrix, 1) // Multidimensional Matrix to store events
};

#endif
