#ifndef MARS_MHThetabarTime
#define MARS_MHThetabarTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TProfile
#include "TProfile.h"
#endif
#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MTime;
class MMcEvt;

class MParList;

class MHThetabarTime : public MH
{
private:
    MTime  *fTime;   //!
    MMcEvt *fMcEvt;

    TProfile   fHist;

public:
    MHThetabarTime(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TProfile *GetHist() { return &fHist; }
    const TProfile *GetHist() const { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    ClassDef(MHThetabarTime, 1) //Profile histogram Thetabar vs. time

};

#endif
