#ifndef MARS_MHTimeDiffTime
#define MARS_MHTimeDiffTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MTime;

class MParList;

class MHTimeDiffTime : public MH
{
private:
    MTime *fTime;   //!
    Int_t  fLastTime;

    TH2D   fHist;

public:
    MHTimeDiffTime(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH2D *GetHist() { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    ClassDef(MHTimeDiffTime, 1) //2D-histogram  time-diff vs. time
};

#endif

