#ifndef MARS_MFilterList
#define MARS_MFilterList

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MFilterList                                                            //
//                                                                         //
//  List of several filters                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TOrdCollection
#include <TOrdCollection.h>
#endif
#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;

class MFilterList : public MFilter
{
private:
    TOrdCollection fFilters;	// Container for the filters

    typedef enum { kEAnd, kEOr, kEXor, kELAnd, kELOr } FilterType_t;
    FilterType_t fFilterType;

    enum { kIsOwner = BIT(14) };

public:
    MFilterList(const char *type="&&");
    MFilterList(MFilterList &ts);
    ~MFilterList()
    {
        if (TestBit(kIsOwner))
            fFilters.SetOwner();
    }

    Bool_t AddToList(MFilter *filter);
    void SetOwner(Bool_t enable=kTRUE) { enable ? SetBit(kIsOwner) : ResetBit(kIsOwner); }

    Bool_t IsExpressionTrue() const;

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void Print(Option_t *opt = "") const;

    ClassDef(MFilterList, 0)		// List to combine several filters logically
};

#endif
