#include <iomanip.h>
#include <fstream.h>
#include <iostream.h>

#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h>

#include "MCosy.h"
#include "MLogManip.h"
#include "base/timer.h"

#define clog(txt) \
    { \
    const Bool_t is = lout.IsOutputDeviceEnabled(MLog::eStdout); \
    lout << edev(MLog::eStdout) << txt << endl; \
    if (is) \
    lout.EnableOutputDevice(MLog::eStdout); \
    }

int main(int argc, char **argv)
{
    Timer time;
    time.Now();

    //
    // this must move to MGCosy !!!! (or MApplication)
    //
    MLog lout("log/cosy.log", kTRUE);
    lout.EnableOutputDevice(MLog::eStdout);

    clog("Starting Cosy at " << time.GetTimeStr() << " ...");

    //
    // start the main window
    //
    clog("- Initialising Root environment.");

    TROOT root("Cosy", "Magic Control System");
    TApplication app("App", &argc, argv);

    //
    // Create the Network. Device: /dev/dpm_00, Rate: 500kbps
    //
    clog("- Constructing MCosy.");
    MCosy *cosy = new MCosy("/dev/dpm_00", 500, lout);

    clog("- Starting MCosy.");
    cosy->Start();

    clog("- Starting mainloop.");
    app.Run(kTRUE);

    clog("- Stopping cosy.");
    cosy->Stop();
    clog("- cosy stopped."); 

    delete cosy;

    clog("- Terminating Program.");
    cout << "The End." << endl;
}
