#ifndef MARS_MMultiDimDistCalc
#define MARS_MMultiDimDistCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHMatrix;
class MParList;
class MHadroness;

class MMultiDimDistCalc : public MTask
{
private:
    Int_t fNum;             // number of distances used for an avarage

    MHMatrix   *fMGammas;   //! Gammas describing matrix
    MHMatrix   *fMHadrons;  //! Hadrons (non gammas) describing matrix

    MHadroness *fHadroness; //! Output container for calculated hadroness

    TList *fData;           //! Used to store the MDataChains to get the event values

public:
    MMultiDimDistCalc(Int_t num, const char *name=NULL, const char *title=NULL);
    ~MMultiDimDistCalc();

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();

    ClassDef(MMultiDimDistCalc, 1) // Task to calculate multidimensional distances
};

#endif
