#ifndef MARS_MHEffOnTime
#define MARS_MHEffOnTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include "TH1.h"
#endif

class TH2D;
class MParList;

class MHEffOnTime : public MH
{
private:
    TH1D fHEffOn;
    TH1D fHProb;
    TH1D fHLambda;
    TH1D fHRdead;

    const char *fVarname;
    const char *fUnit;

public:
    MHEffOnTime(const char *varname=NULL, const char *unit=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH1D *GetHist() { return &fHEffOn; }
    const TH1D *GetHist() const { return &fHEffOn; }

    void Calc(TH2D *hist, const Bool_t Draw);

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    ClassDef(MHEffOnTime, 1) //1D-plot of Delta t vs. Var
};

#endif

