#ifndef MARS_MHHillas
#define MARS_MHHillas

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class TH2F;
class MHillas;

class MHHillas : public MH
{
private:

    TH1F *fLength; //->
    TH1F *fWidth;  //->

    TH1F *fDistC;  //->
    TH1F *fDelta;  //->

    TH1F *fSize;   //->
    TH2F *fCenter; //->

    void SetColors() const;

protected:
    Float_t fMm2Deg;

    Bool_t fUseMmScale;

public:
    MHHillas(const char *name=NULL, const char *title=NULL);
    ~MHHillas();

    void SetMmScale(Bool_t mmscale=kTRUE);
    virtual void SetMm2Deg(Float_t mmdeg);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par);

    TH1F *GetHistLength() { return fLength; }
    TH1F *GetHistWidth()  { return fWidth; }

    TH1F *GetHistDistC()  { return fDistC; }
    TH1F *GetHistDelta()  { return fDelta; }

    TH1F *GetHistSize()   { return fSize; }
    TH2F *GetHistCenter() { return fCenter; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    ClassDef(MHHillas, 1) // Container which holds histograms for the source independent image parameters
};

#endif
