/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void CT1Hillas()
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a CT1 dataset.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamCT1 geomcam;
    plist.AddToList(&geomcam);

    //
    // Setup binning for your histograms.
    //
    MBinning binswidth("BinningWidth");
    binswidth.SetEdges(100, 0, 1);   // 100 bins from 0 to 1 deg

    MBinning binslength("BinningLength");
    binslength.SetEdges(100, 0, 1);  // 100 bins from 0 to 1 deg

    MBinning binsalpha("BinningAlpha");
    binsalpha.SetEdges(90, 0, 90);   // 90 bins from 0 to 90 deg

    MBinning binsdist("BinningDist");
    binsdist.SetEdges(100, 0, 2);    // 100 bins from 0 to 2 deg

    plist.AddToList(&binswidth);
    plist.AddToList(&binslength);
    plist.AddToList(&binsalpha);
    plist.AddToList(&binsdist);

    //
    // Craete the object which hlods the source positions in the camera
    // plain in respect to which the image parameters will be calculated.
    // For real data the containers will be filled by a task.
    //
    MSrcPosCam source("Source")
    source.SetXY(0, 0);

    plist.AddToList(&source);

    //
    // Now setup the tasks and tasklist:
    //
    //  1) read in the data from a ct1 ascii file   MCTReadAscii
    //  2) clean the image                          MImgCleanStd
    //  3) calculate hillas                         MHillasCalc
    //  4) fill the hillas into the histograms      MFillHHillas
    //
    MCT1ReadAscii read("../data/CT1_97_on1.dat");
    //read.AddFile("../data/CT1_97_off1.dat");

    MImgCleanStd   clean;
    MHillasCalc    hcalc;
    MHillasSrcCalc csrc1("Source",  "HillasSource");

    MFillH hfill("MHHillas",   "MHillas");
    MFillH sfill("MHStarMap",  "MHillas");
    MFillH hfill2s("HistSource  [MHHillasSrc]", "HillasSource");

    tlist.AddToList(&read);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&csrc1);
    tlist.AddToList(&hfill);
    tlist.AddToList(&sfill);
    tlist.AddToList(&hfill2s);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    //
    // After the analysis is finished we can display the histograms
    //
    plist.FindObject("MHHillas")->DrawClone();
    plist.FindObject("HistSource")->DrawClone();
    plist.FindObject("MHStarMap")->DrawClone();
}
