#ifndef MARS_MDataArray
#define MARS_MDataArray

/////////////////////////////////////////////////////////////////////////////
//              
//  MDataArray  
//
/////////////////////////////////////////////////////////////////////////////
#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MData;
class MParList;

class MDataArray : public MParContainer
{
    TObjArray fList;

    void StreamPrimitive(ofstream &out) const;

public:
    MDataArray(const char *name=NULL, const char *title=NULL);

    void AddEntry(const TString rule);

    MData &operator[](Int_t i) const;
    Double_t operator()(Int_t i);

    Bool_t PreProcess(const MParList *plist);

    void Print(Option_t *opt = "") const;
    Bool_t AsciiWrite(ostream &out) const;

    Int_t GetNumEntries() const { return fList.GetEntries(); }

    ClassDef(MDataArray, 1) // An array of MData containers
};

#endif
