/////////////////////////////////////////////////////////////////
//
// CORRunHeader
//
//  Created: Thu May 10 15:32:13 2001
//  Author:  Carles Domingo
//  Purpose: Base class for RunHeader-classes
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt CORRunHeader.cxx}

// @subsection Class {\em CORRunHeader}: Implementation

// @code

#include "CORRunHeader.hxx"

void 
CORRunHeader::reset(void) {

  RunNumber = 0.;
  DateRun = 0.;
  VersionPGM = 0.;

  NumObsLev = 0.;

  SlopeSpec = 0.; 
  ELowLim = 0.;   
  EUppLim = 0.;   

  EGS4yn = 0.;
  NKGyn = 0.;

  Ecutoffh = 0.;  
  Ecutoffm = 0.;  
  Ecutoffe = 0.;  
  Ecutoffg = 0.;  

  NFLAIN = 0.;
  NFLDIF = 0.;
  NFLPI0_PIF = 0.;
  NFLCHE_AGM = 0.;

  for (Int_t i=0; i<5; i++ ){
    AATM[i]=0.;
    BATM[i]=0.;
    CATM[i]=0.;
    CETA[i]=0.;
  }
  for (Int_t i=0; i<10; i++){
    HeightLev[i]=0.;
  }
  for (Int_t i=0; i<11; i++){
    CSTRBA[i]=0.;
  }
  for (Int_t i=0; i<20; i++){
    dmmy1[i]=0.;
  }  
  for (Int_t i=0; i<40; i++){
    CKA[i]=0.;
  }
  for (Int_t i=0; i<50; i++){
    C[i]=0.;
  }
  for (Int_t i=0; i<104; i++){
    dmmy2[i]=0.;
  }
}

void 
CORRunHeader::print(void) {

  cout << "  RUNH           :" << (char*)RUNH << endl;
  cout << "  RunNumber      :" << RunNumber << endl;
  cout << "  DateRun        :" << DateRun << endl;
  cout << "  VersionPGM     :" << VersionPGM << endl;

  cout << "  NumObsLev      :" << NumObsLev << endl;
  cout << "  HeightLev[0]   :" << HeightLev[0]  << endl;
                                
  cout << "  SlopeSpec      :" << SlopeSpec << endl;
  cout << "  ELowLim        :" << ELowLim    << endl;
  cout << "  EUppLim        :" << EUppLim    << endl;
                                
  cout << "  EGS4yn         :" << EGS4yn << endl;
  cout << "  NKGyn          :" << NKGyn << endl;
                                
  cout << "  Ecutoffh       :" << Ecutoffh   << endl;
  cout << "  Ecutoffm       :" << Ecutoffm   << endl;
  cout << "  Ecutoffe       :" << Ecutoffe   << endl;
  cout << "  Ecutoffg       :" << Ecutoffg   << endl;
                                
  cout << "  NFLPI0_PIF     :" << NFLPI0_PIF << endl;
  cout << "  NFLCHE_AGM     :" << NFLCHE_AGM << endl;

  cout << flush;
}

void CORRunHeader::transport( COREventHeader *e )
{
  CORRunHeader::reset () ;
  strcpy (RUNH,"RUNH");
  RunNumber      = e->RunNumber;
  DateRun        = e->DateRun;
  VersionPGM     = e->VersionPGM;
  NumObsLev      = e->NumObsLev;
  
  memcpy( HeightLev, e->HeightLev, 10*sizeof(Float_t) );
      
  SlopeSpec      = e->SlopeSpec;
  ELowLim        = e->ELowLim;
  EUppLim        = e->EUppLim;
  EGS4yn         = e->EGS4yn;
  NKGyn          = e->NKGyn;
  Ecutoffh       = e->Ecutoffh;  
  Ecutoffm       = e->Ecutoffm;  
  Ecutoffe       = e->Ecutoffe;  
  Ecutoffg       = e->Ecutoffg;
  
  NFLAIN         = e->NFLAIN;
  NFLDIF         = e->NFLDIF;
  NFLPI0_PIF     = (e->NFLPI0) + 100*(e->NFLPIF)  ;
  NFLCHE_AGM     = (e->NFLCHE) + 100*(e->NFRAGM)  ;
}

// @endcode
