/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz et al,  12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */


void CT1Hillas(const char *filename)
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a Magic root file (raw data file).
    //

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList plist;


    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamCT1 geomcam;
    plist.AddToList(&geomcam);

    //
    // Use this if you want to change the binning of one of
    // the histograms. You can use:
    // BinningConc, BinningConc1, BinningAsym, BinningM3Long,
    // BinningM3Trans, BinningWidth, BinningLength, BinningDist,
    // BinningHeadTail, BinningAlpha, BinningSize, BinningDelta,
    // BinningPixels and BinningCamera
    //
    // For more information see MBinning and the corresponding
    // histograms
    //
    // MBinning binsalpha("BinningAlpha");
    // binsalpha.SetEdges(90, 0, 90);       // 90 bins from 0 to 90 deg
    // plist.AddToList(&binsalpha);

    // MBinning binssize("BinningSize");
    // binssize.SetEdgesLog(50, 1, 1e7);
    // plist.AddToList(&binssize);

    //
    // Craete the object which hlods the source positions in the camera
    // plain in respect to which the image parameters will be calculated.
    // For real data the containers will be filled by a task.
    //
    MSrcPosCam source("Source")
    source.SetXY(0, 0);
    plist.AddToList(&source);

    //
    // Now setup the tasks and tasklist:
    //
    //  1) read in the data from a ct1 ascii file   MCTReadAscii
    //  2) clean the image                          MImgCleanStd
    //  3) calculate hillas                         MHillasCalc
    //  4) fill the hillas into the histograms      MFillHHillas
    //
    MCT1ReadAscii read("../data/CT1_97_on1.dat");
    //read.AddFile("../data/CT1_97_off1.dat");

    MMcPedestalCopy pcopy;
    MMcPedestalNSBAdd pnsb;

    MCerPhotCalc ncalc;
    //
    //  Alternative photon calculation:
    //  Example: use only 2nd to 6th FADC slices for photon calculation:
    //
    //    MCerPhotCalc2 ncalc;
    //    const Float_t x[15]={0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    //    TArrayF w(15,x);
    //    ncalc.SetWeights(w);
    //

    MCameraSmooth   smooth;
    MImgCleanStd    clean;
    MBlindPixelCalc blind;
    //
    // Instead of unmapping the pixels you can also
    //
    // blind.SetUseInterpolation();
    // blind.SetUseCetralPixel();
    //
    MHillasCalc    hcalc;
    MHillasSrcCalc csrc1("Source",  "HillasSource");

    //
    // Uncomment this two line if you want to use MHillasExt instead
    // of MHillas
    //
    //MHillasExt hext;
    //plist.AddToList(&hext);

    MFillH hfill1("MHHillas", "MHillas");
    MFillH hfill2("MHHillasExt");
    MFillH hfill3("MHStarMap", "MHillas");
    MFillH hfill4("HistExtSource [MHHillasExt]", "HillasSource");
    MFillH hfill5("HistSource [MHHillasSrc]", "HillasSource");

    MWriteRootFile write("hillas.root");
    write.AddContainer("HillasSource",  "Hillas");
    write.AddContainer("MHStarMap");
    write.AddContainer("MMcEvt","Hillas");
    write.AddContainer("Source","RunHeaders");

    tlist.AddToList(&read);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clean);
    tlist.AddToList(&blind);

    tlist.AddToList(&hcalc);
    tlist.AddToList(&csrc1);
    tlist.AddToList(&csrc2);

    tlist.AddToList(&hfill1);
    tlist.AddToList(&hfill2);
    tlist.AddToList(&hfill3);
    tlist.AddToList(&hfill4);
    tlist.AddToList(&hfill5);
    tlist.AddToList(&write);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    //
    // After the analysis is finished we can display the histograms
    //
    plist.FindObject("MHHillas")->DrawClone();
    plist.FindObject("MHHillasExt")->DrawClone();
    plist.FindObject("MHStarMap")->DrawClone();
    plist.FindObject("HistSource")->DrawClone();
    plist.FindObject("HistExtSource")->DrawClone();
}

