/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!   Author(s): Harald Kornmayer 1/2001
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MEvtDisp.h"

#include <TGButton.h>       // TGTextButton

#include "MGList.h"
#include "MGFadcDisp.h"

ClassImp(MEvtDisp)

enum {
  kButDispEvt          = 0x100,
  kButDispPedestal     = 0x101,
  kButDispCalibration  = 0x102
};

MEvtDisp::MEvtDisp(const TGWindow *main, const TGWindow *p,
                   const UInt_t w, const UInt_t h)
: MBrowser(main, p, w, h)
{
    TGTextButton *fadcevt = new TGTextButton(fTop1, "FADC Disp for Events",  kButDispEvt);
    TGTextButton *fadcped = new TGTextButton(fTop1, "FADC Disp for PedEvts", kButDispPedestal);
    TGTextButton *fadccal = new TGTextButton(fTop1, "FADC Disp for CalEvts", kButDispCalibration);

    fadcevt->Associate(this);
    fadcped->Associate(this);
    fadccal->Associate(this);

    fList->Add(fadcevt);
    fList->Add(fadcped);
    fList->Add(fadccal);

    TGLayoutHints *laybut = new TGLayoutHints(kLHintsTop|kLHintsLeft, 10, 10, 5, 5);
    fList->Add(laybut);

    fTop1->AddFrame(fadcevt, laybut);
    fTop1->AddFrame(fadcped, laybut);
    fTop1->AddFrame(fadccal, laybut);

    MapSubwindows();

    Layout();

    SetWindowName("EventDispMain");
    SetIconName("EventDispMain");

    MapWindow();
} 

// ======================================================================

Bool_t MEvtDisp::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{     
    // Process events generated by the buttons in the frame.

    if (GET_MSG(msg) != kC_COMMAND || GET_SUBMSG(msg) != kCM_BUTTON)
        return MBrowser::ProcessMessage(msg, parm1, parm2);

    switch (parm1)
    {
    case kButDispEvt:
    case kButDispPedestal:
    case kButDispCalibration:
        if (!InputFileSelected())
        {        
            DisplError("No Input (root) File selected!");
            return kTRUE;
        }

        switch (parm1)
        {
        case kButDispEvt:
            new MGFadcDisp(fInputFile, "Events",
                           fClient->GetRoot(), this, 600, 500);
            return kTRUE;

        case kButDispPedestal:
            new MGFadcDisp(fInputFile , "PedEvts",
                           fClient->GetRoot(), this, 600, 500);
            return kTRUE;

        case kButDispCalibration:
            new MGFadcDisp(fInputFile , "CalEvts",
                           fClient->GetRoot(), this, 600, 500);
            return kTRUE;
        }
        return kTRUE;
    }

    return MBrowser::ProcessMessage(msg, parm1, parm2);
} 
