/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz <mailto:tbretz@astro.uni-wuerzburg.de>, 10/2002
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MContinue                                                               //
//                                                                         //
// Does nothing than return kCONTINUE in the Process-fucntion              //
// (use with filters)                                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MContinue.h"

ClassImp(MContinue);

MContinue::MContinue(const char *name, const char *title)
{
    fName  = name  ? name  : "MContinue";
    fTitle = title ? title : "Task returning kCONTINUE";
}

MContinue::MContinue(MFilter *f, const char *name, const char *title)
{
    fName  = name  ? name  : "MContinue";
    fTitle = title ? title : "Task returning kCONTINUE";

    SetFilter(f);
}
