#ifndef MARS_MCompProbCalc
#define MARS_MCompProbCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcEvt;
class MParList;
class MHadroness;

class MCompProbCalc : public MTask
{
private:
    MHadroness *fHadroness; //! Output container (Hadroness)

    TList *fData;           //! List of MDataChains to be used
    TList *fHistVar;        //! List of variable bin size histograms

    void Fill(TList &list);
    void SetBinningHistVar();

public:
    MCompProbCalc(const char *name=NULL, const char *title=NULL);
    ~MCompProbCalc();

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();

    ClassDef(MCompProbCalc, 1) // Task to calculate composite probabilities
};

#endif
