#ifndef MARS_MHHadronness
#define MARS_MHHadronness

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1D;
class TGraph;
class MParList;
class MMcEvt;
class MHadronness;

class MHHadronness : public MH
{
private:
    const MMcEvt *fMcEvt;            //!
    const MHadronness *fHadronness;    //!

    TH1D* fPhness;        // Hadrons Hadronness
    TH1D* fGhness;        // Gammas Hadronness
    TH1D* fIntPhness;     // Hadrons Acceptance
    TH1D* fIntGhness;     // Gammas Acceptance
    TH1D* fMinDist;       // Minimum Distance to optimum acceptance

    TGraph *fQfac;        // Quality factor
    TGraph *fGraph;       // gamma acceptance vs. hadron acceptance

public:
    MHHadronness(Int_t nbins=100, const char *name=NULL, const char *title=NULL);
    ~MHHadronness();

    Double_t GetGammaAcceptance(Double_t acchad) const;
    Double_t GetHadronAcceptance(Double_t accgam) const;

    TH1D *Getghness() const  { return fGhness; }
    TH1D *Getphness() const  { return fPhness; }
    TH1D *Getighness() const { return fIntGhness; }
    TH1D *Getiphness() const { return fIntPhness; }
    //TH2D *GetHist() const    { return fHist; }

    Float_t GetQ05() const;

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par);
    Bool_t Finalize();

    void Print(Option_t *option="") const;

    void Draw(Option_t *opt="");
    TObject *DrawClone(Option_t *opt="") const;

    ClassDef(MHHadronness, 1) // Gamma/Hadron Separation Quality Histograms
};

#endif
