//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGEmbeddedCanvas.h"

#include <iostream.h>

#include <TList.h>
#include <TCanvas.h>

ClassImp(MGEmbeddedCanvas);

MGEmbeddedCanvas::MGEmbeddedCanvas(const char *name, const TGWindow* p,
                                   const UInt_t width, Float_t range)
    : TRootEmbeddedCanvas(name, p, width+1, width+1, 0/*kRaisedFrame*/),
      fModified(kFALSE), fWidth(width), fRange(range), fPix(2.*range/width)
{
    cout << "MGEmbeddedCanvas: Initializing." << endl;
    fCanvas = GetCanvas();

    cout << "MGEmbeddedCanvas: fCanvas = 0x" << fCanvas << endl;

    cout << "MGEmbeddedCanvas: SetFillColor." << endl;
    fCanvas->SetFillColor(39); // s. TAttFill
    cout << "MGEmbeddedCanvas: fRange=" << fRange << endl;
    if (fRange>0)
        fCanvas->Range(-fRange, -fRange, fRange, fRange);

    fList = new TList;
    fList->SetOwner();

    cout << "MGEmbeddedCanvas: Initializing done." << endl;
}

MGEmbeddedCanvas::~MGEmbeddedCanvas()
{
    delete fList;
}

void MGEmbeddedCanvas::InitCanvas()
{
    MapSubwindows();

    Resize(fWidth, fWidth); //GetDefaultSize()); // ???
    MapWindow();

    fCanvas->SetEditable(kFALSE);
}

void MGEmbeddedCanvas::UpdateCanvas()
{
    if (!fModified)
        return;

    //
    // FIXME: Sometimes (if the canvas couldn't be created correctly:
    // X11 Pixmap error) Update hangs the Gui system.
    //
    // Fixed: Using root 3.01/06 and doing the update from within the
    // mainthread.
    //

    fCanvas->Modified();
    fCanvas->Update();

    fModified = kFALSE;
}
