/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  5/2002 <mailto:(tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  STAR - STandard Analysis and Reconstruction
//
//  This macro is the standard converter to convert raw data into image
//  parameters
//
/////////////////////////////////////////////////////////////////////////////

void star()
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a Magic root file.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Uncomment this two line if you want to use MHillasExt instead
    // of MHillas
    //
    MHillasExt hext;
    plist.AddToList(&hext);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamMagic geomcam;
    plist.AddToList(&geomcam);

    //
    // Craete the object which hlods the source positions in the camera
    // plain in respect to which the image parameters will be calculated.
    // For real data the containers will be filled by a task.
    //
    MSrcPosCam source("Source")
    source.SetXY(0, 0);

    MSrcPosCam antisrc("AntiSrc");
    antisrc.SetXY(240, 0);

    plist.AddToList(&source);
    plist.AddToList(&antisrc);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    MReadMarsFile read("Events");
    read.AddFile("Gammas*.root");
    read.DisableAutoScheme();

    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotCalc      ncalc;

    MBlindPixelCalc   blind;
    blind.SetUseInterpolation();

    MImgCleanStd      clean;
    MHillasCalc       hcalc;
    MHillasSrcCalc    csrc1("Source",  "HillasSource");
    MHillasSrcCalc    csrc2("AntiSrc", "HillasAntiSrc");

    MWriteRootFile write("star.root");
    write.AddContainer("MHillas",       "Events");
    write.AddContainer("HillasSource",  "Events");
    write.AddContainer("HillasAntiSrc", "Events");
    write.AddContainer("MMcEvt",        "Events");
    write.AddContainer("MRawRunHeader", "RunHeaders");
    write.AddContainer("MMcRunHeader",  "RunHeaders");
    write.AddContainer("Source",        "RunHeaders");
    write.AddContainer("AntiSource",    "RunHeaders");

    tlist.AddToList(&read);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&blind);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&csrc1);
    tlist.AddToList(&csrc2);
    tlist.AddToList(&write);

    //
    // Create and setup the eventloop
    //
    MProgressBar bar;

    MEvtLoop evtloop;
    evtloop.SetProgressBar(&bar);
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();
}
