#ifndef MARS_MCT1ReadPreProc
#define MARS_MCT1ReadPreProc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TList;
class MMcEvt;
class MMcTrig;
class MGeomCam;
class MSrcPosCam;
class MCerPhotEvt;
class MPedestalCam;
class MBlindPixels;

struct outputpars;
struct eventrecord;

class MCT1ReadPreProc : public MTask
{
private:
    ifstream     *fIn;          // the inputfile
    MGeomCam     *fGeom;        // camera geometry
    MCerPhotEvt  *fNphot;       // the data container for all data.
    MPedestalCam *fPedest;      // ct1 pedestals
    MMcEvt       *fMcEvt;       // monte carlo data container for MC files
    MMcTrig      *fMcTrig;      // mc data container for trigger information
    MSrcPosCam   *fSrcPos;      // source position in the camera
    TList        *fFileNames;   // Array which stores the \0-terminated filenames
    MBlindPixels *fBlinds;      // Array holding blind pixels

    Int_t fNumPixels;
    Bool_t fIsMcFile;

    UInt_t fNumEvents;
    UInt_t fNumEvent;

    Bool_t OpenNextFile();

    Int_t  GetNumEvents();

    void   ReadPedestals();
    Bool_t ReadHeader();
    Bool_t ReadFooter();
    Bool_t CheckFilePosition();
    void   ProcessHeader(const struct outputpars &outpars);
    void   ProcessEvent(const struct eventrecord &event);

public:
    MCT1ReadPreProc(const char *filename=NULL,
                  const char *name=NULL,
                  const char *title=NULL);

    ~MCT1ReadPreProc();

    void AddFile(const char *fname);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCT1ReadPreProc, 0)	// Reads the CT1 data file
};

#endif

