      SUBROUTINE MOLLER
C                                VERSION 4.00  --  26 JAN 1986/1900
C******************************************************************
C   DISCRETE MOLLER SCATTERING (A CALL TO THIS ROUTINE) HAS BEEN
C   ARBITRARILY DEFINED AND CALCULATED TO MEAN MOLLER SCATTERINGS
C   WHICH IMPART TO THE SECONDARY ELECTRON SUFFICIENT ENERGY THAT
C   IT BE TRANSPORTED DISCRETELY.  THE THRESHOLD TO TRANSPORT AN
C   ELECTRON DISCRETELY IS A TOTAL ENERGY OF AE OR A KINETIC ENERGY
C   OF TE=AE-RM.  SINCE THE KINETIC ENERGY TRANSFER IS ALWAYS, BY
C   DEFINITION, LESS THAN HALF OF THE INCIDENT KINETIC ENERGY, THIS
C   IMPLIES THAT THE INCIDENT ENERGY, EIE, MUST BE LARGER THAN
C   THMOLL=TE*2+RM.  THE REST OF THE COLLISION CONTRIBUTION IS
C   SUBTRACTED CONTINUOUSLY FROM THE ELECTRON AS IONIZATION
C   LOSS DURING TRANSPORT.
C******************************************************************
      DOUBLE PRECISION PEIE,PEKSE2,PESE1,PESE2
      DOUBLE PRECISION PEKIN,H1,DCOSTH,PEKINI
*KEEP,RANDPA.
      COMMON /RANDPA/  FAC,U1,U2,RD,NSEQ,ISEED,KNOR
      DOUBLE PRECISION FAC,U1,U2
      REAL             RD(3000)
      INTEGER          ISEED(103,10),NSEQ
      LOGICAL          KNOR
*KEEP,RUNPAR.
      COMMON /RUNPAR/  FIXHEI,THICK0,HILOECM,HILOELB,
     *                 STEPFC,NRRUN,NSHOW,PATAPE,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,
     *                 CETAPE,
     *                 SHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,
     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE
     *                ,GHEISH,GHESIG
      COMMON /RUNPAC/  DSN,HOST,USER
      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB
      REAL             STEPFC
      INTEGER          NRRUN,NSHOW,PATAPE,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 SHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE
      INTEGER          CETAPE
      CHARACTER*79     DSN
      CHARACTER*20     HOST,USER
 
      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE
     *                ,GHEISH,GHESIG
*KEEP,STACKE.
      COMMON/STACKE/   E,TIME,X,Y,Z,U,V,W,DNEAR,IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIME(60)
      REAL             X(60),Y(60),Z(60),U(60),V(60),W(60),DNEAR(60)
      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP
*KEND.
      COMMON/THRESH/RMT2,RMSQ,ESCD2,AP,API,AE,UP,UE,TE,THMOLL
      COMMON/UPHIOT/THETA,SINTHE,COSTHE,SINPHI, COSPHI,PI,TWOPI,PI5D2
      DOUBLE PRECISION PZERO,PRM,PRMT2,RMI,VC
      COMMON/USEFUL/PZERO,PRM,PRMT2,RMI,VC,RM,MEDIUM,MEDOLD,IBLOBE,ICALL
      COMMON/ACLOCK/NCLOCK,JCLOCK
C_____IF (NCLOCK.GT.JCLOCK) THEN
C______WRITE(MDEBUG,* )' MOLLER:NP=',NP,' IR=',IR(NP),' IOBS=',IOBS(NP)
C______CALL AUSGB2
C_____END IF
      PEIE=E(NP)
      EIE=PEIE
      PEKIN=PEIE-PRM
      EKIN=PEKIN
      PEKINI=1./PEKIN
      EKINI=PEKINI
      T0=EKIN*RMI
      E0=T0+1.0
      EXTRAE = EIE - THMOLL
      E02=E0*E0
      BETAI2=E02/(E02-1.0)
      EP0=TE*EKINI
      G1=(1.-2.*EP0)*BETAI2
      G2=T0*T0*(1./E02)
      G3=(2.*T0+1.)*(1./E02)
931   CONTINUE
       CALL RMMAR(RD,2,2)
       RNNO27=RD(1)
       RNNO28=RD(2)
       BR = TE/(EKIN-EXTRAE*RNNO27)
       R=BR/(1.-BR)
       REJF4=G1*(1.+G2*BR*BR+R*(R-G3))
       IF((RNNO28.LE.REJF4))GO TO932
      GO TO 931
932   CONTINUE
      PEKSE2=BR*EKIN
      PESE1=PEIE-PEKSE2
      PESE2=PEKSE2+PRM
      E(NP)=PESE1
      E(NP+1)=PESE2
      H1=(PEIE+PRM)*PEKINI
      DCOSTH=MIN(H1*(PESE1-PRM)/(PESE1+PRM),1.D0)
      SINTHE=SQRT(1.D0-DCOSTH)
      COSTHE=SQRT(DCOSTH)
      CALL UPHI(2,1)
      NP=NP+1
      IQ(NP)=3
      DCOSTH=MIN(H1*(PESE2-PRM)/(PESE2+PRM),1.D0)
      SINTHE=-SQRT(1.D0-DCOSTH)
      COSTHE=SQRT(DCOSTH)
      CALL UPHI(3,2)
      RETURN
      END
