#ifndef NETWORK_H
#define NETWORK_H

#include "canopen.h"
#include "nodedrv.h"

class Network : public CanOpen
{
private:
    NodeDrv *fNodes[32];
    int fNodeInitialized[32];

    void HandleSDO(BYTE_t node, BYTE_t cmd, WORD_t idx, BYTE_t subidx, LWORD_t data, timeval *tv);
    void HandlePDO1(BYTE_t node, BYTE_t *data, timeval_t *tv);
    void HandlePDO2(BYTE_t node, BYTE_t *data, timeval_t *tv);
    void HandlePDO3(BYTE_t node, BYTE_t *data, timeval_t *tv);
    void HandlePDO4(BYTE_t node, BYTE_t *data, timeval_t *tv);

    void InitNodes();
    void StopNodes();

public:
    Network(const char *dev, const int baud, MLog &out=gLog);

    void SetNode(NodeDrv *drv);

    NodeDrv *operator[](int i) { return fNodes[i]; }
    NodeDrv *GetNode(int i)    { return fNodes[i]; }

    virtual void Start();
    virtual void Stop();

    bool HasError() const;
    bool HasZombie() const;

    bool RebootZombies();
    void CheckConnections();

    ClassDef(Network, 0) // collection of nodes (nodedrv)
};

#endif
