#ifndef MARS_MCerPhotAnal
#define MARS_MCerPhotAnal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCerPhotAnal                                                            //
//                                                                         //
// Integrates the time slices of one pixel and substracts the pedestal     //
// (offset) value                                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MRawEvtData;
class MPedestalCam;
class MCerPhotEvt;
class MRawRunHeader;

class MCerPhotAnal : public MTask
{
    MPedestalCam  *fPedestals;  // Pedestals of all pixels in the camera
    MRawEvtData   *fRawEvt;     // raw event data (time slices)
    MCerPhotEvt   *fCerPhotEvt; // Cerenkov Photon Event used for calculation
    MRawRunHeader *fRunHeader;  //  RunHeader information
 
public:
    MCerPhotAnal(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCerPhotAnal, 0)   // Task to calculate cerenkov photons from raw data
};

#endif
